/* --------------------------------------------------------------
  pie_chart_legend.js 2019-06-20
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


(function() {
	
	'use strict';
	
	let legendId = 'pieChartLegend',
		removePieChartLegend = function() {
			
			let legend = document.getElementById(legendId);
			
			if (legend !== null) {
				legend.remove();
			}
		},
		getNextColor = function (index, colors) {
		
			if (index < colors.length) {
				
				return colors[index];
			}

			while (index >= colors.length) {

				index -= colors.length;
			}

			return colors[index];
		},
		buildLegendHtml = function(legendData, colors) {
			
			console.log(legendData.length, colors.length);
		
			let legend = document.createElement('div');
			legend.id = legendId;
			
			legendData.forEach(function(item, index) {
				let pageName,
					visitorCount,
					color = getNextColor(index, colors);
				
				[pageName, visitorCount] = item;
				
				let colorTile = document.createElement('div');
				colorTile.className = 'pie-chart-color-tie';
				colorTile.style.backgroundColor = color;
				colorTile.innerHTML = "\u00A0"; // &nbsp;
				
				let legendContent = document.createElement('span');
				legendContent.innerHTML = pageName + ' : ' + visitorCount;
				
				let row = document.createElement('div');
				row.appendChild(colorTile);
				row.appendChild(legendContent);
				
				legend.appendChild(row);
			});
			
			let $gm_box_content = $('#gm_box_content');
			
			legend.style.top = ($gm_box_content.position().top + 50) + 'px';
			legend.style.left = ($gm_box_content.position().left + $gm_box_content.width() + 50) + 'px';
			
			document.body.appendChild(legend);
			
			$(document).ajaxStart(removePieChartLegend);
		};
	
	buildLegendHtml(pieChartData, pieChartColors)
	
})();